/* FILE: mlocate.h                              (D. Tottingham  12/26/90)

This is an include file of defines, data structure definitions and
external declarations that are common in the mlocate module.

*/

#ifndef _MLOCATE_
#define _MLOCATE_

/************************************************************************
                               INCLUDES

************************************************************************/
#include "mconst.h"
#include "mqueue.h"


/************************************************************************
                                DEFINES

************************************************************************/
#define LOCATION_ENABLED        TRUE
#define MAX_LOCATIONS           10


/************************************************************************
                         EXTERNAL DECLARATIONS

These functions can be called from all modules that include this file.

************************************************************************/
PUBLIC void l_display_location (FILE *);
PUBLIC Q_LOCATION far * l_get_first_location ();
PUBLIC Q_LOCATION far * l_get_location ();
PUBLIC FLAG l_get_location_status ();
PUBLIC Q_LOCATION far * l_get_next_location ();
PUBLIC void l_initialize ();
PUBLIC FLAG l_locate_event ();
PUBLIC void l_reset_location ();
PUBLIC void l_set_location_status ();
PUBLIC void l_toggle_location_status ();

#endif
